//
//  Material.fsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//

#ifdef OGL_ES2
#	ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#	else
precision mediump float;
#	endif
#	define prec_high highp
#	define prec_med mediump
#	define prec_low lowp
#else 
#	define prec_high
#	define prec_med 
#	define prec_low 
#endif
 
varying prec_med vec3 v_world_xyz;
varying prec_med vec3 v_world_normal;
uniform prec_med vec3 u_frustumPlanes;

float depthFact = 512.0;

prec_med vec2 PackFloat16( prec_med float depth )
{
    depth /= 4.0;
    prec_med float Integer = floor(depth);
    prec_med float fraction= fract(depth);
    
    return vec2( Integer/256.0, fraction);    
}

void main()
{
	prec_low vec4 color;
	prec_med float depth = v_world_xyz.z / -u_frustumPlanes.z;
	
	color.rg = PackFloat16(depth * depthFact); 
	color.ba = normalize( v_world_normal ).xy * 0.5 + 0.5;
 
	
	gl_FragColor = color;
}


